
// Pixel shader input structure
struct PS_INPUT
{
    float4 Position   : POSITION;
    float2 Texture    : TEXCOORD0;
};

// Pixel shader output structure
struct PS_OUTPUT
{
    float4 Color   : COLOR0;
};

// Global variables
sampler2D Texture0;
const float fX;
const float fY;
const float fZ;
const float4 fColour;
const bool bMode;

float3 fLight;

PS_OUTPUT ps_main( in PS_INPUT In )
{
    fLight = normalize(float3(fX,fY,fZ));
    // Output pixel
    PS_OUTPUT Out;
    Out.Color = tex2D(Texture0,In.Texture.xy);
    Out.Color.xyz = normalize(Out.Color.xyz - float3(0.5,0.5,0.5));
    if (bMode)
    {
        Out.Color.a *= 1.0f - dot(fLight,Out.Color.xyz);
        Out.Color.rgb = fColour.rgb;
    }
    else
    {
        Out.Color.rgb = fColour.rgb * dot(fLight,Out.Color.xyz);
    }
    return Out;
}

// Effect technique
technique tech_main
{
    pass P0
    {
        // shaders
        VertexShader = NULL;
        PixelShader  = compile ps_2_0 ps_main();
    }  
}